/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.ai.goals.jobs;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.RandomXS128;
import com.badlogic.gdx.utils.Array;
import technology.rocketjump.undermount.entities.behaviour.HumanoidBehaviour;
import technology.rocketjump.undermount.entities.components.ProfessionsComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.ai.goals.Goal;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalException;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.GoalFailedException;
import technology.rocketjump.undermount.entities.model.ai.goals.exceptions.NoJobAvailableException;
import technology.rocketjump.undermount.entities.model.ai.goals.jobs.CollectItemFromFurnitureInventoryGoal;
import technology.rocketjump.undermount.entities.model.ai.goals.jobs.EquipItemGoal;
import technology.rocketjump.undermount.entities.model.ai.goals.jobs.JobCompletedGoal;
import technology.rocketjump.undermount.entities.model.ai.goals.jobs.PickUpItemGoal;
import technology.rocketjump.undermount.entities.model.ai.goals.jobs.PlaceItemGoal;
import technology.rocketjump.undermount.entities.model.ai.goals.jobs.RequestJobGoal;
import technology.rocketjump.undermount.entities.model.ai.goals.pathfinding.GoToLocationGoal;
import technology.rocketjump.undermount.entities.model.ai.goals.pathfinding.SwitchFacingGoal;
import technology.rocketjump.undermount.jobs.model.Job;
import technology.rocketjump.undermount.jobs.model.JobType;
import technology.rocketjump.undermount.mapping.model.TiledMap;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.messaging.types.JobCompletedMessage;
import technology.rocketjump.undermount.misc.VectorUtils;
import technology.rocketjump.undermount.rooms.ItemAllocation;

public class WorkOnJobGoal
extends Goal {
    private final TiledMap map;
    private final MessageDispatcher messageDispatcher;
    private Job assignedJob;
    private boolean noJobsAvailable;
    boolean completed;

    public WorkOnJobGoal(Entity parentEntity, MessageDispatcher messageDispatcher, TiledMap map) {
        super(parentEntity);
        this.map = map;
        this.messageDispatcher = messageDispatcher;
        this.childGoals.addFirst(new RequestJobGoal(parentEntity, this, messageDispatcher));
    }

    @Override
    public void update(float deltaTimeSeconds) throws GoalException {
        block11: {
            try {
                Goal currentChildGoal = (Goal)this.childGoals.peek();
                if (currentChildGoal != null) {
                    currentChildGoal.update(deltaTimeSeconds);
                    if (currentChildGoal.isComplete()) {
                        this.childGoals.pop();
                    }
                    break block11;
                }
                if (this.noJobsAvailable) {
                    throw new NoJobAvailableException("No jobs available for entity's professions");
                }
                if (this.inPositionToWorkOnJob()) {
                    if (this.assignedJob.getType().equals((Object)JobType.HAULING)) {
                        ItemAllocation itemAllocation = this.assignedJob.getItemAllocation();
                        this.childGoals.add(new PickUpItemGoal(this.parentEntity, this, this.messageDispatcher, itemAllocation, this.map));
                        this.childGoals.add(new GoToLocationGoal(this.parentEntity, VectorUtils.toVector(itemAllocation.getTargetPosition()), this.messageDispatcher, this.map));
                        this.childGoals.add(new PlaceItemGoal(this.parentEntity, this.messageDispatcher, itemAllocation, this.map));
                        this.childGoals.add(new JobCompletedGoal(this.parentEntity, this));
                        ((HumanoidBehaviour)this.parentEntity.getBehaviourComponent()).setWorkOnJobNext(true);
                        return;
                    }
                    if (this.assignedJob.getType().equals((Object)JobType.COLLECT_ITEM)) {
                        this.childGoals.add(new CollectItemFromFurnitureInventoryGoal(this.parentEntity, this, this.messageDispatcher, this.assignedJob.getTargetEntityId(), this.map));
                        this.childGoals.add(new JobCompletedGoal(this.parentEntity, this));
                        return;
                    }
                    ProfessionsComponent professionsComponent = this.parentEntity.getComponent(ProfessionsComponent.class);
                    float workDone = deltaTimeSeconds * professionsComponent.getSkillLevel(this.assignedJob.getRequiredProfession());
                    this.assignedJob.applyWorkDone(workDone);
                    if (this.assignedJob.getTotalWorkToDo() <= this.assignedJob.getWorkDoneSoFar()) {
                        this.messageDispatcher.dispatchMessage(604, new JobCompletedMessage(this.assignedJob, professionsComponent, this.parentEntity));
                        this.childGoals.add(new RequestJobGoal(this.parentEntity, this, this.messageDispatcher));
                    }
                    break block11;
                }
                throw new GoalFailedException("Something went wrong while working on job");
            }
            catch (GoalException e) {
                if (this.assignedJob != null) {
                    if (this.assignedJob.getItemAllocation() != null) {
                        this.messageDispatcher.dispatchMessage(701, this.assignedJob.getItemAllocation());
                    }
                    System.out.println("Cancelling job because: " + e.getMessage());
                    this.messageDispatcher.dispatchMessage(602, this.assignedJob);
                }
                throw e;
            }
        }
    }

    private boolean inPositionToWorkOnJob() {
        if (this.assignedJob == null) {
            return false;
        }
        if (this.assignedJob.getType().isAccessedFromAdjacentTile()) {
            GridPoint2 entityTile = new GridPoint2((int)Math.floor(this.parentEntity.getLocationComponent().getWorldPosition().x), (int)Math.floor(this.parentEntity.getLocationComponent().getWorldPosition().y));
            return entityTile.dst2(this.assignedJob.getJobLocation()) <= 1.0f;
        }
        GridPoint2 entityTile = new GridPoint2((int)Math.floor(this.parentEntity.getLocationComponent().getWorldPosition().x), (int)Math.floor(this.parentEntity.getLocationComponent().getWorldPosition().y));
        return entityTile.equals(this.assignedJob.getJobLocation());
    }

    @Override
    public boolean isComplete() {
        return this.completed || this.noJobsAvailable;
    }

    public void setAssignedJob(Job assignedJob) {
        GridPoint2 targetTile;
        if (assignedJob == null) {
            this.noJobsAvailable = true;
            return;
        }
        this.assignedJob = assignedJob;
        if (assignedJob.getItemTypeRequiredForWork() != null) {
            this.childGoals.addLast(new EquipItemGoal(this.parentEntity, this.messageDispatcher, assignedJob.getItemTypeRequiredForWork()));
        }
        if (assignedJob.getType().isAccessedFromAdjacentTile()) {
            targetTile = null;
            Array<GridPoint2> navigableTiles = new Array<GridPoint2>();
            for (MapTile neighbourTile : this.map.getOrthogonalNeighbours(assignedJob.getJobLocation().x, assignedJob.getJobLocation().y).values()) {
                if (!neighbourTile.isNavigable()) continue;
                navigableTiles.add(neighbourTile.getTilePosition());
            }
            if (navigableTiles.size == 1) {
                targetTile = (GridPoint2)navigableTiles.get(0);
            } else if (navigableTiles.size > 1) {
                targetTile = (GridPoint2)navigableTiles.get(new RandomXS128().nextInt(navigableTiles.size));
            }
        } else {
            targetTile = assignedJob.getJobLocation();
        }
        this.childGoals.addLast(new GoToLocationGoal(this.parentEntity, VectorUtils.toVector(targetTile), this.messageDispatcher, this.map));
        if (assignedJob.getType().isAccessedFromAdjacentTile()) {
            this.childGoals.addLast(new SwitchFacingGoal(this.parentEntity, VectorUtils.toVector(assignedJob.getJobLocation())));
        } else if (assignedJob.getSecondaryLocation() != null) {
            this.childGoals.addLast(new SwitchFacingGoal(this.parentEntity, VectorUtils.toVector(assignedJob.getSecondaryLocation())));
        }
    }

    public Job getAssignedJob() {
        return this.assignedJob;
    }
}

